package openrtb3

type Video struct {
	Mime        []string `json:"mime,omitempty"`
	Ptype       int      `json:"ptype,omitempty"`
	Pos         int      `json:"pos,omitempty"`
	Delay       int      `json:"delay,omitempty"`
	Skip        int      `json:"skip,omitempty"`
	Skipmin     int      `json:"skipmin,omitempty"`
	Skipafter   int      `json:"skipafter,omitempty"`
	Playmethod  []int    `json:"playmethod,omitempty"`
	Playend     int      `json:"playend,omitempty"`
	Api         []int    `json:"api,omitempty"`
	Ctype       []int    `json:"ctype,omitempty"`
	W           int      `json:"w,omitempty"`
	H           int      `json:"h,omitempty"`
	Minbitr     int      `json:"minbitr,omitempty"`
	Maxbitr     int      `json:"maxbitr,omitempty"`
	Mindur      int      `json:"mindur,omitempty"`
	Maxdur      int      `json:"maxdur,omitempty"`
	MaxExtended int      `json:"maxextended,omitempty"` // Maximum extended video ad duration
	Delivery    []int    `json:"delivery,omitempty"`
	Linear      int      `json:"linear,omitempty"`
	Boxing      int      `json:"boxing,omitempty"`
	Comp        []*Comp  `json:"comp,omitempty"`
	Comptype    []int    `json:"comptype,omitempty"`
}

type Comp struct {
	Display *Display `json:"display,omitempty"`
}
